# programme python pour tracer et modéliser ln(DT) = f(t)

import matplotlib.pyplot as plt
import csv
import numpy as np
from scipy.stats import linregress


#fonction permettant de lire le fichier csv et de modifier la virgule par un point le cas échéant
def readColCSV(fichier,sep,n) :
    file=open(fichier,"r")
    reader=csv.reader(file,delimiter=sep)
    col=[]
    for row in reader :
        if(row[n][0].isdigit()) :
            notation_point=row[n].replace(",",".")
            col.append(float(notation_point))
    return col

#nom du fichier à traiter
fichier=input("Quel est le nom du fichier (sans l'extension .csv)?")+".csv"

#Appel de la fonction pour récupérer et lire les données.
t=readColCSV(fichier,";",0)
T=readColCSV(fichier, ";",1)

#entrée de la valeur de la température extérieure
Text=float(input('quelle est la valeur de la température extérieure'))

#création de la liste correspondant aux différentes valeurs de la température
T=np.array(T)

#calcul de lnDT
lnDT=

#Création de la variable x
x=np.array(t)
#Création de la variable y
y=lnDT
#détermination des paramètres du modèle de droite le plus proche des points expérimentaux
(a,b,rho,_,_)=linregress(x,y)

#affichage des paramètres a et b de la droite
print("a =",a,"s-1","b =",b)

#définition du modèle
def droite(x):
    return b + a*x
ligne = droite(x)

#tracé de la courbe ln(DT)=f(t)
plt.grid()
plt.title("ln(DT) = f(t)")

axes = plt.gca()
axes.set_ylim(0, 5)

plt.ylabel('Ln(DT)')
plt.xlabel('temps (en s)')
for i in range(len(t)):
    plt.plot(t[i],lnDT[i],'r+')

#tracé du modèle
plt.plot(x,ligne)

plt.savefig("ln(DT) = f(t)")
plt.show()


